<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    public function OrderStatus()
    {
        return $this->belongsTo('App\Models\OrderStatus', 'order_status');
    }

    public function Comments()
    {
        return $this->hasOne('App\Models\Comment', 'comment_id');
    }

    public function refil()
    {
        return $this->hasOne('App\Models\Refil', 'order_id');
    }

    public function drugs()
    {
        return $this->hasMany('App\Models\Drug', 'order_id');
    }

}